/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWMapListCellRenderer
extends JLabel
implements ListCellRenderer {
    public VWMapListCellRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            if (value != null && value instanceof VWMap) {
                VWMap map = (VWMap)value;
                String mapName = map.getName();
                if (list != null) {
                    this.setComponentOrientation(list.getComponentOrientation());
                    this.setFont(list.getFont());
                    this.setEnabled(list.isEnabled());
                    if (isSelected) {
                        this.setBackground(list.getSelectionBackground());
                        this.setForeground(list.getSelectionForeground());
                    } else {
                        this.setBackground(list.getBackground());
                        this.setForeground(list.getForeground());
                    }
                }
                if (VWStringUtils.compare(mapName, "Workflow") == 0) {
                    this.setText(VWResource.s_mainMapLabel.toString(mapName));
                } else {
                    this.setText(mapName);
                }
            } else {
                this.setText(null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }
}

